using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.Globalization;

namespace quicksdk
{
    public class OrderInfo{
        public string goodsID;
        public string skuType;
        public string goodsDesc;
        public string cpOrderID;
        public string extrasParams;
        public double amount;
        public string currency;
        public string callBackUrl;
    };

    public class GameRoleInfo
    {
        public string serverName;
        public string serverId;
        public string gameRoleName;
        public string gameRoleID;
        public string vipLevel;
        public string gameRoleLevel;
    };

    public class GoogleSku
    {
        public string productId;
        public string type;
        public string title;
        public string name;
        public string price;
        public long price_amount_micros;
        public string price_currency_code;
        public string description;
        public string skuDetailsToken;
    };

    // 错误信息
    public class ErrorMsg
    {
        public string errMsg;
        public int code;
    }

    // 用户信息，登录回调中使用
    public class UserInfo : ErrorMsg
    {
        public string uid;
        public string userName;
        public string token;
        public string openType;
        public bool isGuest;
    }

    // 用户绑定第三方用户信息
    public class BindUserInfo
    {
        public string uid;
        public string appleAccountName;
        public string emailAccountName;
        public string fbAccountName;
        public string googleAccountName;
        public string lineAccountName;
        public string naverAccountName;
        public string playAccountName;
        public string twitterAccountName;
        public string taptapAccountName;
        public string vkAccountName;
        public bool isBindApple;
        public bool isBindEmail;
        public bool isBindFacebook;
        public bool isBindGoogle;
        public bool isBindLine;
        public bool isBindNaver;
        public bool isBindPlay;
        public bool isBindTapTap;
        public bool isBindTwitter;
        public bool isBindVk;
    }

    // 支付信息，支付回调中使用
    public class PayResult
    {
        public string orderId;

        public string extraParam;
    }

    public class QuickSDKImp
    {
        private static QuickSDKImp _instance;

        public static QuickSDKImp getInstance() {
            if( null == _instance ) {
                _instance = new QuickSDKImp();
            }
            return _instance;
        }

        public void setListener(QuickSDKListener listener)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.setListener(listener);
        }

        public void init()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.init();
        }

        public void login ()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.login();
        }

        public void googleLogin ()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.googleLogin();
        }

        public void facebookLogin ()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.facebookLogin();
        }

        public void freeLogin ()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.freeLogin();
        }

        public void logout ()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.logout();
        }

        public void userTrash ()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.userTrash();
        }

        public void userTrashNoUI ()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.userTrashNoUI();
        }

        public void pay (OrderInfo orderInfo, GameRoleInfo gameRoleInfo)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.pay(orderInfo, gameRoleInfo);
        }

        public void updateRoleInfoWith(GameRoleInfo gameRoleInfo)
        {

            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.updateRoleInfo(gameRoleInfo);

        }

        public void afUpdateRoleInfo(int isCreate, GameRoleInfo gameRoleInfo)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.afUpdateRoleInfo(isCreate, gameRoleInfo);
        }

        public void facebookEvent(string eventName,double valueNum,Dictionary<string, string> eventParams)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.facebookEvent(eventName, valueNum, eventParams);
        }

        public void facebookInitiatedCheckoutEvent(string goodsName, string goodsId, string goodsType, int numItems, bool paymentInfoAvailable, string currency, double totalPrice)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.facebookInitiatedCheckoutEvent (goodsName, goodsId, goodsType, numItems, paymentInfoAvailable, currency, totalPrice);
        }

        public void facebookPurchase(double purchaseAmount, String currency, Dictionary<string, string> eventParams)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.facebookPurchase(purchaseAmount, currency, eventParams);
        }

        public void appsFlyerEvent(string eventName,Dictionary<string, string> eventParams)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.appsFlyerEvent(eventName, eventParams);
        }

        public void firebaseEvent(string eventName,Dictionary<string, string> eventParams)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.firebaseEvent(eventName, eventParams);
        }

        public void adjustEvent(string eventToken)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.adjustEvent(eventToken);
        }

        public void adjustEvent(string eventToken,Dictionary<string, string> extendParams)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.adjustEvent(eventToken, extendParams);
        }

        public void adjustEvent(string eventToken, string orderId, double amount,string currency)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.adjustEvent(eventToken, orderId, amount, currency);
        }

        public void adjustEvent(string eventToken, string orderId, double amount,string currency,Dictionary<string, string> extendParams)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.adjustEvent(eventToken, orderId, amount, currency, extendParams);
        }

        public void adjustAdRevenue(string source, double revenue, string currency, int impressionsCount,string revenueNetwork,
        string revenueUnit,string adRevenuePlacement, Dictionary<string, string> extendParams)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.adjustAdRevenue(source, revenue, currency, impressionsCount, revenueNetwork,revenueUnit,adRevenuePlacement,extendParams);
        }

        public void tapDBEvent(string name, JObject properties)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.tapDBEvent(name, properties);
        }

        public void tapDBRegisterStaticProperties(JObject properties )
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.tapDBRegisterStaticProperties(properties);
        }

        public void tapDBUnregisterStaticProperty(string propertyName )
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.tapDBUnregisterStaticProperty(propertyName);
        }

        public void tapDBClearStaticProperties()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.tapDBClearStaticProperties();
        }

        public void tapDBDeviceUpdate(JObject properties )
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.tapDBDeviceUpdate(properties);
        }

        public void tapDBDeviceInitialize(JObject properties )
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.tapDBDeviceInitialize(properties);
        }

        public void tapDBDeviceAdd(JObject properties )
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.tapDBDeviceAdd(properties);
        }

        public void tapDBUserUpdate(JObject properties )
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.tapDBUserUpdate(properties);
        }

        public void tapDBUserInitialize(JObject properties )
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.tapDBUserInitialize(properties);
        }

        public void tapDBUserAdd(JObject properties )
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.tapDBUserAdd(properties);
        }

        public void callFacebookSharePost(string serverId,string roleId )
        {

            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.callFacebookSharePost(serverId,roleId);

        }


        public void fbShareUrl(string url )
        {

            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.fbShareUrl(url);

        }

        public void fbShareImg(string img )
        {

            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.fbShareImg(img);

        }

        public void shareToTikTok(string path)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.shareToTikTok(path);
        }

        public void shareToTikTok(List<string> filePaths)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.shareToTikTok(filePaths);
        }

        public void shareVideoToTikTok(string path)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.shareVideoToTikTok(path);
        }

        public void shareToIns(string path)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.shareToIns(path);
        }

        public void userCenter( )
        {

            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.userCenter();

        }

        public void closeFloat( )
        {

            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.closeFloat();

        }

        public void showFloat( )
        {

            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.showFloat();

        }

        public void queryGoogleSku(List<string> goodsIds)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.queryGoogleSku(goodsIds);
        }

        public Dictionary<string, string> getCountryInfo()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            return androidSupport.getCountryInfo();
        }
        public string getAppsFlyerId()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            return androidSupport.getAppsFlyerId();
        }

        public void bindUser(string bindType)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.bindUser(bindType);
        }

        public string getUserId()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            return androidSupport.getUserId();
        }

        public void initCustomService(string appId, string uid, string userName, string roleId, string roleName, string serverName, string vipLv, string channelCode, string deviceName, string title)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.initCustomService(appId,uid,userName,roleId,roleName,serverName,vipLv,channelCode,deviceName,title);
        }

        public void goChatActivity(){
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.goChatActivity();
        }

        public void singleGameOrderFinish(string sdkOrderId)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.singleGameOrderFinish(sdkOrderId);
        }

        public void thinkingDataLogin(string identification)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.thinkingDataLogin(identification);
        }

        public void thinkingDataSetSuperProperties(JObject properties)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.thinkingDataSetSuperProperties(properties);
        }

        public void thinkingDataEnableAutoTrack(int type)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.thinkingDataEnableAutoTrack(type);
        }

        public void thinkingDataTrack(string eventName,JObject properties)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.thinkingDataTrack(eventName, properties);
        }

        public void thinkingDataUserSet(JObject properties)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.thinkingDataUserSet(properties);
        }

        public bool checkHasPermission(string permission)
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            return androidSupport.checkHasPermission(permission);
        }

        public void openReview()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.openReview();
        }

        public void getAdjustId()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.getAdjustId();
        }

        public void hideUserCenterLogout()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.hideUserCenterLogout();
        }

        public void hideAutoLoginWaiting()
        {
            QuickUnitySupportAndroid androidSupport = QuickUnitySupportAndroid.getInstance();
            androidSupport.hideAutoLoginWaiting();
        }
    }


    public class QuickUnitySupportAndroid {

        AndroidJavaObject ao;

        private static QuickUnitySupportAndroid instance;

        private QuickUnitySupportAndroid() {
            AndroidJavaClass ac = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
            ao = ac.GetStatic<AndroidJavaObject>("currentActivity");
        }


        public void pay(OrderInfo orderInfo, GameRoleInfo gameRoleInfo)
        {
            if (orderInfo == null)
            {
                Debug.LogError("call pay error, orderInfo is null");
                return;
            }
            ao.Call("requestPay", orderInfo.goodsDesc,orderInfo.cpOrderID,orderInfo.extrasParams, StringUtil.FormatDouble(orderInfo.amount),orderInfo.goodsID, orderInfo.skuType,
                orderInfo.currency, orderInfo.callBackUrl,
                gameRoleInfo.gameRoleID, gameRoleInfo.gameRoleLevel,  gameRoleInfo.gameRoleName, gameRoleInfo.serverName,  gameRoleInfo.vipLevel );
        }

        public static QuickUnitySupportAndroid getInstance()
        {
            if (instance == null)
            {
                instance = new QuickUnitySupportAndroid();
            }

            return instance;
        }

        public void setListener(QuickSDKListener listener)
        {
            Debug.Log("gameObject is " + listener.gameObject.name);
            if (listener == null)
            {
                Debug.LogError("set QuickSDKListener error, listener is null");
                return;
            }
            string gameObjectName = listener.gameObject.name;
            if (ao == null)
            {
                Debug.LogError("setListener error, current activity is null");
            }
            else
            {
                ao.Call("setUnityGameObjectName", gameObjectName);
            }
        }

        public void login()
        {
            ao.Call("requestLogin");
        }

        public void init()
        {
            ao.Call("doInit");
        }

        public void googleLogin()
        {
            ao.Call("requestGoogleLogin");
        }

        public void facebookLogin()
        {
            ao.Call("requestFacebookLogin");
        }

        public void freeLogin()
        {
            ao.Call("requestFreeLogin");
        }

        public void logout()
        {
            ao.Call("requestLogout");
        }
        public void callFacebookSharePost(string serverId,string roleId)
        {
            ao.Call("requestShare",serverId,roleId);
        }


        public void fbShareUrl(string url ){

            Debug.Log("fbShareUrl "+url);
            ao.Call("requestShareUrl",url ,"");
        }

        public void fbShareImg(string imgPath ){

            Debug.Log("fbShareImg "+imgPath);
            ao.Call("requestShareImg",imgPath ,"");
        }

        public void shareToTikTok(string imgPath ){
            Debug.Log("shareToTikTok "+imgPath);
            ao.Call("requestShareToTikTok",imgPath);
        }

        public void shareToTikTok(List<string> filePaths){
            Debug.Log("shareToTikTok "+filePaths);
            ao.Call("requestShareToTikTok2",string.Join(",", filePaths.ToArray()));
        }

        public void shareVideoToTikTok(string path ){
            Debug.Log("shareVideoToTikTok "+path);
            ao.Call("requestShareToTikTokVideo",path);
        }

        public void shareToIns(string imgPath ){
            Debug.Log("shareToIns "+imgPath);
            ao.Call("requestShareToIns",imgPath);
        }

        public void userCenter()
        {
            ao.Call("requestUserCenter");
        }

        public void showFloat()
        {
            ao.Call("requestShowFloat");
        }

        public void closeFloat()
        {
            ao.Call("requestCloseFloat");
        }

        public string getUserId()
        {
            return ao.Call<string>("getUserId");
        }

        public void updateRoleInfo(GameRoleInfo gameRoleInfo)
        {
            if (gameRoleInfo.Equals(null))
            {
                Debug.LogError("updateRoleInfo is error, gameRoleInfo is null");
                return;
            }

            string serverName = String.IsNullOrEmpty(gameRoleInfo.serverName) ? "" : gameRoleInfo.serverName;
            string serverId = String.IsNullOrEmpty(gameRoleInfo.serverId) ? "" : gameRoleInfo.serverId;

            string roleName = String.IsNullOrEmpty(gameRoleInfo.gameRoleName) ? "" : gameRoleInfo.gameRoleName;
            string roleId = String.IsNullOrEmpty(gameRoleInfo.gameRoleID) ? "" : gameRoleInfo.gameRoleID;

            string vipLevel = String.IsNullOrEmpty(gameRoleInfo.vipLevel) ? "" : gameRoleInfo.vipLevel;
            string roleLevel = String.IsNullOrEmpty(gameRoleInfo.gameRoleLevel) ? "" : gameRoleInfo.gameRoleLevel;

            ao.Call("requestUpdateRole",
                serverName,
                serverId,
                roleName,
                roleId,
                vipLevel,
                roleLevel);
            Debug.LogWarning("updateRoleInfo executed");
        }

        public void afUpdateRoleInfo(int isCreate, GameRoleInfo gameRoleInfo)
        {

        }

        public void facebookEvent(string eventName,double valueNum,Dictionary<string, string> eventParams)
        {
            ao.Call("requestFacebookEvent",eventName,valueNum,JsonConvert.SerializeObject(eventParams));
        }

        public void facebookInitiatedCheckoutEvent(string goodsName, string goodsId, string goodsType, int numItems, bool paymentInfoAvailable, string currency, double totalPrice)
        {
            ao.Call("requestFacebookInitiatedCheckout",goodsName, goodsId, goodsType, numItems, paymentInfoAvailable, currency, totalPrice);
        }

        public void facebookPurchase(double purchaseAmount, String currency, Dictionary<string, string> eventParams)
        {
            ao.Call("requestFacebookPurchase",purchaseAmount,currency,JsonConvert.SerializeObject(eventParams));
        }

        public void appsFlyerEvent(string eventName,Dictionary<string, string> eventParams)
        {
            ao.Call("requestAppsFlyerEvent",eventName,JsonConvert.SerializeObject(eventParams));
        }

        public void firebaseEvent(string eventName,Dictionary<string, string> eventParams)
        {
            ao.Call("requestFirebaseEvent",eventName,JsonConvert.SerializeObject(eventParams));
        }

        public void adjustEvent(string eventToken)
        {
            ao.Call("requestAdjustEvent",eventToken);
        }

        public void adjustEvent(string eventToken, Dictionary<string, string> extendParams)
        {
            ao.Call("requestAdjustEvent",eventToken, JsonConvert.SerializeObject(extendParams));
        }

        public void adjustEvent(string eventToken, string orderId, double amount,string currency )
        {
            ao.Call("requestAdjustEvent",eventToken, orderId, StringUtil.FormatDouble(amount), currency);
        }

        public void adjustEvent(string eventToken, string orderId, double amount,string currency, Dictionary<string, string> extendParams)
        {
            ao.Call("requestAdjustEvent",eventToken, orderId, StringUtil.FormatDouble(amount), currency, JsonConvert.SerializeObject(extendParams));
        }

        public void adjustAdRevenue(string source, double revenue, string currency, int impressionsCount,string revenueNetwork,
        string revenueUnit,string adRevenuePlacement, Dictionary<string, string> extendParams)
        {
            ao.Call("requestAdjustAdRevenue",source, StringUtil.FormatDouble(revenue), currency, impressionsCount,revenueNetwork,revenueUnit,adRevenuePlacement,JsonConvert.SerializeObject(extendParams));
        }

        public void queryGoogleSku(List<string> goodsIds)
        {
            ao.Call("requestQueryGoogleSku",string.Join(",", goodsIds.ToArray()));
        }

        public Dictionary<string, string> getCountryInfo()
        {
            string jsonStr = ao.Call<string>("requestCountryInfo");
            Dictionary<string, string> result = new Dictionary<string, string>();
            result.Add("ip",JObject.Parse(jsonStr)["ip"].ToString());
            result.Add("ipCountryCode",JObject.Parse(jsonStr)["ipCountryCode"].ToString());
            return result;
        }

        public string getAppsFlyerId()
        {
            return ao.Call<string>("requestAppsFlyerId");
        }

        public void tapDBEvent(string name, JObject properties )
        {
            ao.Call("requestTapDBTrackEvent",name, properties.ToString());
        }

        public void tapDBRegisterStaticProperties(JObject properties )
        {
            ao.Call("requestTapDBRegisterStaticProperties", properties.ToString());
        }

        public void tapDBUnregisterStaticProperty(string propertyName )
        {
            ao.Call("requestTapDBUnregisterStaticProperty", propertyName);
        }

        public void tapDBClearStaticProperties()
        {
            ao.Call("requestTapDBClearStaticProperties");
        }

        public void tapDBDeviceUpdate(JObject properties )
        {
            ao.Call("requestTapDBDeviceUpdate", properties.ToString());
        }

        public void tapDBDeviceInitialize(JObject properties )
        {
            ao.Call("requestTapDBDeviceInitialize", properties.ToString());
        }

        public void tapDBDeviceAdd(JObject properties )
        {
            ao.Call("requestTapDBDeviceAdd", properties.ToString());
        }

        public void tapDBUserUpdate(JObject properties )
        {
            ao.Call("requestTapDBUserUpdate", properties.ToString());
        }

        public void tapDBUserInitialize(JObject properties )
        {
            ao.Call("requestTapDBUserInitialize", properties.ToString());
        }

        public void tapDBUserAdd(JObject properties )
        {
            ao.Call("requestTapDBUserAdd", properties.ToString());
        }

        public void bindUser(string bindType)
        {
            ao.Call("requestBindUser", bindType);
        }

        public void userTrash()
        {
            ao.Call("requestUserTrash");
        }

        public void userTrashNoUI()
        {
            ao.Call("requestUserTrashNoUI");
        }

        public void initCustomService(string appId, string uid, string userName, string roleId, string roleName, string serverName, string vipLv, string channelCode, string deviceName, string title)
        {
            ao.Call("requestCustomInit",appId,uid,userName,roleId,roleName,serverName,vipLv,channelCode,deviceName,title);
        }

        public void goChatActivity()
        {
            ao.Call("requestGoChatActivity");
        }

        public void singleGameOrderFinish(string sdkOrderId)
        {
            ao.Call("requestSingleGameOrderFinish", sdkOrderId);
        }

        public void thinkingDataLogin(string id)
        {
            ao.Call("requestTDLogin",id);
        }

        public void thinkingDataSetSuperProperties(JObject properties )
        {
            ao.Call("requestTDSetSuperProperties", properties.ToString());
        }

        public void thinkingDataEnableAutoTrack(int type)
        {
            ao.Call("requestTDEnableAutoTrack",type);
        }

        public void thinkingDataTrack(string name, JObject properties )
        {
            ao.Call("requestTDTrack",name, properties.ToString());
        }

        public void thinkingDataUserSet(JObject properties )
        {
            ao.Call("requestTDUserSet", properties.ToString());
        }

        public bool checkHasPermission(string permission)
        {
            return ao.Call<bool>("hasPermission", permission);
        }

        public void openReview()
        {
            ao.Call("requestOpenReview");
        }

        public void getAdjustId()
        {
            ao.Call("requestAdjustId");
        }

        public void hideAutoLoginWaiting()
        {
            ao.Call("hideAutoLoginWaiting");
        }

        public void hideUserCenterLogout()
        {
            ao.Call("hideUserCenterLogout");
        }
    }

    public class StringUtil
    {
        // 静态方法，将 double 类型的变量转换为字符串，并确保小数点不是逗号
        public static string FormatDouble(double number)
        {
        // 使用指定文化区域（InvariantCulture）来确保小数点的正确显示
            return number.ToString(CultureInfo.InvariantCulture);
        }
    }

}

